<?php
    /* 
     * Database Configuration
     * 
     * STRICT .env ONLY - No fallbacks, no .htaccess, no system environment
     * Configuration must be in .env file or installer will be triggered.
     */

    // Load .env file - REQUIRED
    $env_file = __DIR__ . '/../.env';
    if (!file_exists($env_file)) {
        // No .env file - redirect to installer
        $current_file = basename($_SERVER['PHP_SELF']);
        $current_dir = basename(dirname($_SERVER['PHP_SELF']));
        
        if ($current_file !== 'installer_ajax.php' && $current_dir !== 'installer') {
            if (file_exists(__DIR__ . '/installer_ajax.php')) {
                header('Location: ' . dirname($_SERVER['PHP_SELF']) . '/installer/');
                exit('.env file not found. Please run the installer.');
            } else {
                die('ERROR: .env file not found. Please create a .env file with your database credentials.');
            }
        }
    }

    // Load .env file
    require_once(__DIR__ . '/env.php');

    // Get configuration ONLY from .env file (via $_ENV, not getenv)
    // This ensures we ONLY read from .env, not from .htaccess or system environment
    $db_server = $_ENV['DB_SERVER'] ?? '';
    $db_username = $_ENV['DB_USERNAME'] ?? '';
    $db_password = $_ENV['DB_PASSWORD'] ?? '';
    $db_name = $_ENV['DB_NAME'] ?? '';
    $base_url = $_ENV['BASE_URL'] ?? '';

    // Check if database configuration is complete (ALL fields required)
    $is_configured = !empty($db_server) && 
                     !empty($db_username) && 
                     !empty($db_name) && 
                     !empty($base_url);

    // If not configured, redirect to installer
    if (!$is_configured) {
        $current_file = basename($_SERVER['PHP_SELF']);
        $current_dir = basename(dirname($_SERVER['PHP_SELF']));
        
        // Don't redirect if we're already in the installer
        if ($current_file !== 'installer_ajax.php' && $current_dir !== 'installer') {
            // Check if installer exists
            if (file_exists(__DIR__ . '/installer_ajax.php')) {
                header('Location: ' . dirname($_SERVER['PHP_SELF']) . '/installer/');
                exit('Database not configured in .env file. Please run the installer.');
            } else {
                die('ERROR: Database not configured in .env file. Required fields: DB_SERVER, DB_USERNAME, DB_NAME, BASE_URL');
            }
        }
    }

    // Define constants - NO DEFAULTS, .env ONLY
    define('DB_SERVER', $db_server);
    define('DB_USERNAME', $db_username);
    define('DB_PASSWORD', $db_password); // Can be empty
    define('DB_NAME', $db_name);
    define('BASE_URL', $base_url);
    
    /* Attempt to connect to MySQL database */
    $mysqli = new mysqli(DB_SERVER, DB_USERNAME, DB_PASSWORD, DB_NAME);
    
    // Set charset to UTF-8 for security and proper encoding
    if (!$mysqli->set_charset("utf8mb4")) {
        error_log("Error loading character set utf8mb4: " . $mysqli->error);
        die("Error loading character set utf8mb4");
    }
    
    // Base URL for file paths
    $baseUrl = BASE_URL;

    // Check connection
    if($mysqli->connect_error){
        // Don't expose database errors in production
        error_log("Database connection failed: " . $mysqli->connect_error);
        
        // If installer exists, redirect there
        if (file_exists(__DIR__ . '/installer_ajax.php')) {
            header("Location: " . dirname($_SERVER['PHP_SELF']) . '/installer/?error=connection_failed');
            exit();
        }
        
        die("ERROR: Could not connect to database. Please check your .env configuration.");
    }
?>